const { contextBridge, ipcRenderer } = require('electron');

contextBridge.exposeInMainWorld('electronAPI', {
    getInitialData: () => ipcRenderer.invoke('get-initial-data'),
    getLobbyList: () => ipcRenderer.invoke('request-lobby-list'),
    getUsername: () => ipcRenderer.invoke('get-username'),
    findGameImage: (options) => ipcRenderer.invoke('find-game-image', options),
    showSaveDialog: (options) => ipcRenderer.invoke('electron.dialog.showSaveDialog', options),
    getDownloadedGames: (consoleName) => ipcRenderer.invoke('get-downloaded-games', consoleName),
    getRelayConfig: () => ipcRenderer.invoke('get-relay-config'),

    playGame: (gamePath) => ipcRenderer.invoke('request-play-game', gamePath),
    playNetplayHost: (gamePath) => ipcRenderer.invoke('request-play-netplay-host', gamePath),
    playNetplayClient: (options) => ipcRenderer.invoke('request-play-netplay-client', options),
    saveGameApp: (gamePath) => ipcRenderer.invoke('request-save-game-app', gamePath),
    saveGameExternal: (options) => ipcRenderer.invoke('request-save-game-external', options),

    setUsername: (username) => ipcRenderer.send('set-username', username),
    setRelayConfig: (config) => ipcRenderer.send('set-relay-config', config),
    toggleFavorite: (options) => ipcRenderer.send('toggle-favorite-game', options),
    openSavedGamesFolder: () => ipcRenderer.send('request-open-saved-games-folder'),
    addToQueue: (options) => ipcRenderer.send('add-game-to-queue', options),
    savePromptResponse: (options) => ipcRenderer.send('save-prompt-response', options),
    killEmuApp: (pid) => ipcRenderer.send('kill-emu-app', pid),
    quitApp: () => ipcRenderer.send('app-quit'),
    suspendPc: () => ipcRenderer.send('suspend-pc'),
    shutdownPc: () => ipcRenderer.send('execute-shutdown'),
    restartPc: () => ipcRenderer.send('execute-restart'),

    openExternalLink: (url) => ipcRenderer.send('open-external-link', url),

    onEmuProgress: (callback) => ipcRenderer.on('emu-progress-update', (_event, value) => callback(value)),
    onEmuExit: (callback) => ipcRenderer.on('emu-process-exit', (_event, value) => callback(value)),
    onShowSavePrompt: (callback) => ipcRenderer.on('show-save-prompt', (_event, value) => callback(value)),
    onFolderOpenError: (callback) => ipcRenderer.on('folder-open-error', (_event, value) => callback(value)),
    onEmuLog: (callback) => ipcRenderer.on('emu-log-message', (_event, value) => callback(value)),
});